<?php
declare(strict_types=1);
require_once __DIR__ . '/bootstrap.php';

admin_require_login();

$licenseId = (int)($_GET['license_id'] ?? 0);
if ($licenseId <= 0) {
    header('Location: index.php');
    exit;
}

$pdo = gmap_pdo();

$licenseStmt = $pdo->prepare('SELECT * FROM licenses WHERE id = :id LIMIT 1');
$licenseStmt->execute([':id' => $licenseId]);
$license = $licenseStmt->fetch();
if (!$license) {
    admin_set_flash('License not found.');
    header('Location: index.php');
    exit;
}

$logsStmt = $pdo->prepare(
    'SELECT id, event_type, time, ip, hwid_hash, user_agent, message
     FROM license_logs
     WHERE license_id = :license_id
     ORDER BY time DESC
     LIMIT 1000'
);
$logsStmt->execute([':license_id' => $licenseId]);
$logs = $logsStmt->fetchAll();
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>License Logs</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>
<body>
<div class="container">
    <div class="topbar">
        <div>
            <h1>License Logs</h1>
            <p class="muted">
                <?= admin_h(gmap_format_license_key((string)$license['license_key'])) ?> |
                <?= admin_h((string)$license['user_label']) ?>
            </p>
        </div>
        <div class="topbar-actions">
            <a class="btn secondary" href="index.php">Back</a>
        </div>
    </div>

    <section class="card">
        <div class="table-wrap">
            <table>
                <thead>
                <tr>
                    <th>Time (UTC)</th>
                    <th>Event</th>
                    <th>IP</th>
                    <th>HWID Hash</th>
                    <th>User Agent</th>
                    <th>Message</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($logs as $log): ?>
                    <tr>
                        <td><?= admin_h((string)$log['time']) ?></td>
                        <td><?= admin_h((string)$log['event_type']) ?></td>
                        <td><?= admin_h((string)$log['ip']) ?></td>
                        <td class="mono"><?= admin_h((string)$log['hwid_hash']) ?></td>
                        <td><?= admin_h((string)$log['user_agent']) ?></td>
                        <td><?= admin_h((string)$log['message']) ?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </section>
</div>
</body>
</html>
