-- GMapScraperPRO centralized licensing schema
-- Run this in cPanel phpMyAdmin (SQL tab) against your target database.

SET NAMES utf8mb4;
SET time_zone = '+00:00';

CREATE TABLE IF NOT EXISTS licenses (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    license_key VARCHAR(64) NOT NULL,
    user_label VARCHAR(255) NOT NULL,
    email VARCHAR(255) NULL,
    status ENUM('active', 'revoked', 'paused') NOT NULL DEFAULT 'active',
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    expires_at DATETIME NOT NULL,
    bound_hwid CHAR(64) NULL,
    bound_at DATETIME NULL,
    last_seen_at DATETIME NULL,
    last_ip VARCHAR(45) NULL,
    notes TEXT NULL,
    max_devices TINYINT UNSIGNED NOT NULL DEFAULT 1,
    UNIQUE KEY uq_licenses_license_key (license_key),
    KEY idx_licenses_status (status),
    KEY idx_licenses_expires_at (expires_at),
    KEY idx_licenses_last_seen_at (last_seen_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS license_logs (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    license_id BIGINT UNSIGNED NULL,
    event_type ENUM(
        'activate', 'validate', 'deny', 'revoke', 'reset',
        'create', 'extend', 'pause', 'resume', 'delete'
    ) NOT NULL,
    time DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ip VARCHAR(45) NULL,
    hwid_hash CHAR(64) NULL,
    user_agent VARCHAR(255) NULL,
    message VARCHAR(255) NULL,
    KEY idx_license_logs_license_id (license_id),
    KEY idx_license_logs_event_type (event_type),
    KEY idx_license_logs_time (time),
    CONSTRAINT fk_license_logs_license_id
        FOREIGN KEY (license_id) REFERENCES licenses(id)
        ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS admin_users (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(64) NOT NULL,
    password_hash VARCHAR(255) NOT NULL,
    active TINYINT(1) NOT NULL DEFAULT 1,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY uq_admin_users_username (username)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
