<?php
declare(strict_types=1);
require_once __DIR__ . '/bootstrap.php';

admin_require_login();

$pdo = gmap_pdo();
$flash = admin_get_flash();
$csrf = admin_csrf_token();

$licensesStmt = $pdo->query(
    'SELECT id, license_key, user_label, email, status, created_at, expires_at, bound_hwid, bound_at, last_seen_at, last_ip, notes
     FROM licenses
     ORDER BY created_at DESC
     LIMIT 500'
);
$licenses = $licensesStmt->fetchAll();
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>GMapScraperPRO License Admin</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>
<body>
<div class="container">
    <div class="topbar">
        <div>
            <h1>License Dashboard</h1>
            <p class="muted">Centralized control for activation, revocation, expiry and HWID binding.</p>
        </div>
        <div class="topbar-actions">
            <a class="btn secondary" href="logout.php">Logout</a>
        </div>
    </div>

    <?php if ($flash !== ''): ?>
        <div class="alert"><?= admin_h($flash) ?></div>
    <?php endif; ?>

    <section class="card">
        <h2>Create License</h2>
        <form method="post" action="actions.php" class="grid-form">
            <input type="hidden" name="csrf_token" value="<?= admin_h($csrf) ?>">
            <input type="hidden" name="action" value="create_license">

            <label>User Label / Name</label>
            <input type="text" name="user_label" required>

            <label>Email (optional)</label>
            <input type="email" name="email">

            <label>Duration (days)</label>
            <input type="number" min="1" max="3650" value="30" name="duration_days" required>

            <label>Notes (optional)</label>
            <input type="text" name="notes">

            <button type="submit">Create</button>
        </form>
    </section>

    <section class="card">
        <h2>Licenses</h2>
        <div class="table-wrap">
            <table>
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Key</th>
                    <th>User</th>
                    <th>Status</th>
                    <th>Expiry</th>
                    <th>Bound HWID</th>
                    <th>Last Seen</th>
                    <th>Last IP</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($licenses as $row): ?>
                    <?php
                    $id = (int)$row['id'];
                    $keyDisplay = gmap_format_license_key((string)$row['license_key']);
                    ?>
                    <tr>
                        <td><?= $id ?></td>
                        <td class="mono"><?= admin_h($keyDisplay) ?></td>
                        <td><?= admin_h((string)$row['user_label']) ?></td>
                        <td><span class="status <?= admin_h((string)$row['status']) ?>"><?= admin_h((string)$row['status']) ?></span></td>
                        <td><?= admin_h((string)$row['expires_at']) ?></td>
                        <td class="mono"><?= admin_h((string)($row['bound_hwid'] ?? '')) ?></td>
                        <td><?= admin_h((string)($row['last_seen_at'] ?? '')) ?></td>
                        <td><?= admin_h((string)($row['last_ip'] ?? '')) ?></td>
                        <td>
                            <div class="action-stack">
                                <form method="post" action="actions.php">
                                    <input type="hidden" name="csrf_token" value="<?= admin_h($csrf) ?>">
                                    <input type="hidden" name="license_id" value="<?= $id ?>">
                                    <input type="hidden" name="action" value="set_status">
                                    <select name="status">
                                        <option value="active">active</option>
                                        <option value="paused">paused</option>
                                        <option value="revoked">revoked</option>
                                    </select>
                                    <button type="submit" class="btn small">Set</button>
                                </form>

                                <form method="post" action="actions.php">
                                    <input type="hidden" name="csrf_token" value="<?= admin_h($csrf) ?>">
                                    <input type="hidden" name="license_id" value="<?= $id ?>">
                                    <input type="hidden" name="action" value="extend_license">
                                    <input type="number" name="extend_days" min="1" max="3650" value="30">
                                    <button type="submit" class="btn small">Extend</button>
                                </form>

                                <form method="post" action="actions.php">
                                    <input type="hidden" name="csrf_token" value="<?= admin_h($csrf) ?>">
                                    <input type="hidden" name="license_id" value="<?= $id ?>">
                                    <input type="hidden" name="action" value="reset_hwid">
                                    <button type="submit" class="btn small warning">Reset HWID</button>
                                </form>

                                <form method="post" action="actions.php" onsubmit="return confirm('Delete this license permanently?');">
                                    <input type="hidden" name="csrf_token" value="<?= admin_h($csrf) ?>">
                                    <input type="hidden" name="license_id" value="<?= $id ?>">
                                    <input type="hidden" name="action" value="delete_license">
                                    <button type="submit" class="btn small danger">Delete</button>
                                </form>

                                <a class="btn small secondary" href="license_logs.php?license_id=<?= $id ?>">Logs</a>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </section>
</div>
</body>
</html>
