# GMapScraperPRO cPanel Deployment

## Target structure on hosting

```
/home/<cpanel_user>/
  _secure/
    config.php
  public_html/
    api/
      .htaccess
      activate.php
      validate.php
      ping.php
      common.php
      db.php
      token.php
    admin/
      .htaccess
      bootstrap.php
      login.php
      logout.php
      index.php
      actions.php
      license_logs.php
      assets/
        admin.css
```

If you cannot place config outside web root, use:
`public_html/_secure/config.php` and keep `public_html/_secure/.htaccess`.

## Setup steps

1. In cPanel, create a MySQL database and user.
2. Import `sql/schema.sql` via phpMyAdmin.
3. Create `config.php` from `public_html/_secure/config.php.example` and set:
   - database credentials
   - `hmac_secret` (long random string)
   - admin username/password hash
4. Upload `public_html/api/*` and `public_html/admin/*`.
5. Verify health:
   - `POST https://your-domain.com/api/ping.php`
6. In client environment set:
   - `GMAP_LICENSE_API_BASE_URL=https://your-domain.com/api`

## Admin password hash

Generate a hash once in PHP:

```php
<?php echo password_hash("YourStrongPasswordHere", PASSWORD_DEFAULT);
```

Paste into `admin_password_hash` in `config.php`.
